/***************************************************************************
 *                          Zanoza Modeler v3.x                            *
 *      This is unpublished propietary source code of Zanoza Software.     *
 *      The copyright notice does not evidence any actual or intended      *
 *                    publication of such source code.                     *
 *                                                                         *
 *                 Copyright (c) 2002-2012 Zanoza Software.                *
 *                                                                         *
 *                        All rights reserved.                             *
 ***************************************************************************
 *--------------------------------------------------------------------------
 * @author:   Oleg M.
 *--------------------------------------------------------------------------
 * @purpose:  ZModeler 3.x Color + Diffuse Texture + Specular + Environment
 *--------------------------------------------------------------------------
 * @histroy: 27.08.2011. Created
<[[
UserName = "Diffuse+Spec+Env"
Description = "Color, Diffuse, Specular and Environment map"
Version  = 1.1
Options  = SOLID SPECULAR ENVIRONMENT FRESNEL
Samplers = DETAIL SPECMAP ENVMAP
ManualUV1 = v.vUV01.xy
ManualUV2 = v.vUV01.zw
ManualUV3 = v.vUV23.xy
ManualUV4 = v.vUV23.zw
EnvUV = v.vUVRefl.xy
WorldUV = v.vUVRefl.zw
AlphaRegister = 29

[DETAIL]
Variable = g_Diffuse
Register = 0
Mask = R G B A RGB
Scale = 32.R
Level = 30.R
AngularLevel = 30.G

[SPECMAP]
Variable = g_SpecMap
Register = 1
Mask = R G B A RGB
Scale = 32.G
Level = 30.B
AngularLevel = 30.A
	
[ENVMAP]
Variable = g_EnvMap
Register = 2
Mask = RGB
Scale = 32.B
Level = 31.R
AngularLevel = 31.B


[ALPHABLEND]

[ALPHATEST]

[CUSTOM.1]
Name = Opacity Amplifier
Slot = 31.G
Type = float
Min = 0.0
Max = 1.0
Default = 0.0

[CUSTOM.2]
Name = Fresnel
Slot = 31.A
Type = float
Min = 0.001
Max = 0.3
Default = 0.018


]]>
*/

#pragma pack_matrix( row_major ) 

struct VS_INPUT
{
    float4 vPosition        : POSITION;
    float4 vNormal          : NORMAL;
    float4 vColorDif        : COLOR0;
    float4 vUV01            : TEXCOORD0;
    float4 vUV23            : TEXCOORD1;
    float4 vDeformPosition  : TEXCOORD5;
    float4 vDeformNormal    : COLOR2;
    uint4  vBones           : BLENDINDICES;
    float4 vWeights         : BLENDWEIGHT;
};

struct VS_OUTPUT
{
    float4 vPosition  : POSITION;   //transformed position
    float4 vColorDif  : COLOR0;
    //precomputed stuff:
    float4 vNormal    : TEXCOORD0;  //world-space normal;
    float4 vViewer    : TEXCOORD1;  //camera-space position;
    float4 vUV01      : TEXCOORD2;
    float4 vUV23      : TEXCOORD3;
    float4 vUVRefl    : TEXCOORD4;
};

//----------------------------------------------------------------------
// globals:
//----------------------------------------------------------------------

#include "zmCommon.inl"

float4      g_alpha          : register(c29);  //[minlevel:testvalue, maxlevel, mapaffect, angular level]
float4      g_textureAmp     : register(c30);  //[diff amp, diff angular, spec amp, spec angular]
float4      g_environment    : register(c31);  //[level, refl opacity amp, angular level, fresnel value]
float4      g_textureScale   : register(c32);  //[diff scale, spec scale, refl scale, 0]

// textures:
sampler     g_Diffuse        : register(s[0]);
sampler     g_SpecMap        : register(s[1]);
sampler     g_EnvMap         : register(s[2]);

#ifdef VERTEX_SHADER
VS_OUTPUT mainVS(in VS_INPUT v)
{
    VS_OUTPUT output = (VS_OUTPUT)0;
    output.vNormal = v.vNormal;
    float4 vTangent = (float4)0;
    output.vPosition = transformInput(v, output.vNormal, vTangent, output.vViewer);
    output.vColorDif = any(v.vColorDif.rgb) ? v.vColorDif : 1;
    output.vUVRefl.zw = v.vPosition.xz;

    output.vUV01 = v.vUV01;
    output.vUV23 = v.vUV23;
    output.vUVRefl.xy = (mul(output.vNormal.xyz, (float3x3)g_mView).xy+1)/2;

    return output;
}
#endif //VERTEX_SHADER

#ifdef PIXEL_SHADER
//------------------------------------------------------------
//  PixelShader: generic Color+Dif+Refl;
//------------------------------------------------------------
float4 mainPS(in VS_OUTPUT v) : COLOR0
{
    float4 oColor;
    float4 CONST_TEXEL   = float4(1,1,1,1);
    float4 VCOLOR_TEXEL  = v.vColorDif;
    float4 DETAIL_TEXEL  = tex2D(DETAIL_SOURCE, DETAIL_UV_SOURCE/g_textureScale.x);
    float4 SPECMAP_TEXEL = tex2D(SPECMAP_SOURCE, SPECMAP_UV_SOURCE/g_textureScale.y);
    float4 ENVMAP_TEXEL  = tex2D(ENVMAP_SOURCE, ENVMAP_UV_SOURCE/g_textureScale.z);

    float3 light = -g_lightDir.xyz;
    float4 Temp   = float4(1,1,0,saturate(dot(v.vViewer.xyz, v.vNormal.xyz))); 
    
#ifdef SPECULAR_ENABLED
    float3 normal = normalize(v.vNormal.xyz);
    float3 halfSpec = normalize(light + v.vViewer.xyz);
    Temp.xy = float2(dot(normal, light), dot(normal, halfSpec));
    float4 LitCoef = lit(Temp.x, Temp.y, g_colors[2].a);
#else
    float4 LitCoef = float4(1, saturate(dot(light, v.vNormal.xyz)), 0, 0);
#endif //SPECULAR_ENABLED
    // alter diffuse light factor by ambient illumitaion addon:
    LitCoef.y = saturate(LitCoef.y + (g_ambientLight.r + g_ambientLight.g + g_ambientLight.b)/3);

    float3 fDiffuseColor    = (DETAIL_INPUT)DETAIL_MASK;
    float3 fSpecMapColor    = (SPECMAP_INPUT)SPECMAP_MASK;
    float3 fEnvironColor    = (ENVMAP_INPUT*ENVMAP_INPUT_MASK)ENVMAP_MASK;
    //
    // diff angular value
    if (g_textureAmp.y >= 0)
      Temp.x = lerp(1, Temp.w, g_textureAmp.y)*g_textureAmp.x;
    else
      Temp.x = lerp(1, 1-Temp.w, abs(g_textureAmp.y))*g_textureAmp.x;
    //
    // specmap angular value
    if (g_textureAmp.w >= 0)
      Temp.y = lerp(1, Temp.w, g_textureAmp.w)*g_textureAmp.z;
    else
      Temp.y = lerp(1, 1-Temp.w, abs(g_textureAmp.w))*g_textureAmp.z;
    //
    // refl angular value
    if (g_environment.z >= 0)
      Temp.z = lerp(1, Temp.w, g_environment.z)*g_environment.x;
    else
      Temp.z = lerp(1, 1-Temp.w, abs(g_environment.z))*g_environment.x;

    float fresnel = (1-LitCoef.y);
    LitCoef.w = fresnel*fresnel;
    LitCoef.w = LitCoef.w*LitCoef.w;
    LitCoef.w = saturate(mad(LitCoef.w*fresnel, 1-saturate(g_environment.w), g_environment.w));
    fEnvironColor = fEnvironColor*saturate(Temp.z+(0.5 + 0.5*g_environment.x)*LitCoef.w);
    
    oColor.rgb =
                // ambient: 
                (g_colors[0].rgb + 0.2*v.vColorDif.rgb + 0.8*fDiffuseColor*g_ambientLight.rgb)*g_ambientLight.rgb +
                // diffuse component:
                g_colors[1].rgb*v.vColorDif.rgb*lerp(1, fDiffuseColor, Temp.x*(DETAIL_INPUT_MASK))*max(g_colors[3].a, LitCoef.y) +
                // specular component:
                g_colors[2].rgb*(fSpecMapColor*Temp.y*(SPECMAP_INPUT_MASK))*saturate(LitCoef.z) +
                // reflection component:
                fEnvironColor +
                // emissive component:
                g_colors[3].rgb*g_colors[3].a;

#ifdef ALPHABLEND_ENABLED
    if (g_alpha.w >= 0)
      Temp.x = lerp(1, Temp.w, g_alpha.w);
    else
      Temp.x = lerp(1, 1-Temp.w, abs(g_alpha.w));
    oColor.a = (saturate(g_colors[1].a*lerp(1, ALPHABLEND_INPUT, g_alpha.z)*ALPHABLEND_VERTEXCOLOR*Temp.x*Temp.x + 
                        length(fEnvironColor)*g_environment.y))*g_alpha.y;
#else
    oColor.a = g_alpha.y;
#endif//ALPHABLEND_ENABLED
#ifdef ALPHATEST_ENABLED
    clip(oColor.a - g_alpha.x);
#endif//ALPHATEST_ENABLED
    return oColor;
}
#endif //PIXEL_SHADER

