/***************************************************************************
 *                          Zanoza Modeler v3.x                            *
 *      This is unpublished propietary source code of Zanoza Software.     *
 *      The copyright notice does not evidence any actual or intended      *
 *                    publication of such source code.                     *
 *                                                                         *
 *                 Copyright (c) 2002-2012 Zanoza Software.                *
 *                                                                         *
 *                        All rights reserved.                             *
 ***************************************************************************
 *--------------------------------------------------------------------------
 * @author:   Oleg M.
 *--------------------------------------------------------------------------
 * @purpose:  ZModeler 3.x Generic ambient+diffuse+specular+emissive shader
 *--------------------------------------------------------------------------
 * @histroy: 22.08.2011. Created
<[[
UserName = "Color"
Description = "Color only shader"
Version  = 1.1
Options  = SOLID SPECULAR
AlphaRegister = 29

]]>
 */

#pragma pack_matrix( row_major ) 

struct VS_INPUT
{
    float4 vPosition        : POSITION;
    float4 vNormal          : NORMAL;
    float4 vTangent         : TANGENT;
    float4 vColorDif        : COLOR0;
    float4 vDeformPosition  : TEXCOORD5;
    float4 vDeformNormal    : COLOR2;
    uint4  vBones           : BLENDINDICES;
    float4 vWeights         : BLENDWEIGHT;
};

struct VS_OUTPUT
{
    float4 vPosition  : POSITION;   //transformed position
    float4 vColorDif  : COLOR0;
    //precomputed stuff:
    float4 vNormal    : TEXCOORD1;  //world-space normal;
    float4 vViewer    : TEXCOORD2;  //camera-space position;
};


#include "zmCommon.inl"
float4      g_alpha          : register(c29);  //[minlevel:testvalue, maxlevel, mapaffect, angular level]

#ifdef VERTEX_SHADER
VS_OUTPUT mainVS(in VS_INPUT v)
{
    VS_OUTPUT output = (VS_OUTPUT)0;
    output.vNormal = v.vNormal;
    float4 vTangent = v.vTangent;
    output.vPosition = transformInput(v, output.vNormal, vTangent, output.vViewer);
    output.vColorDif = any(v.vColorDif.rgb) ? v.vColorDif : 1;
    
    return output;
}
#endif //VERTEX_SHADER

#ifdef PIXEL_SHADER
//------------------------------------------------------------
//  PixelShader: generic color + specular highlight
//------------------------------------------------------------
float4 mainPS(in VS_OUTPUT v) : COLOR0
{
    float4 oColor;
    float4 CONST_TEXEL   = float4(1,1,1,1);
    float4 VCOLOR_TEXEL  = v.vColorDif;
    float3 light = -g_lightDir.xyz;
    float2 Temp = 1; 
#ifdef SPECULAR_ENABLED
    float3 normal = normalize(v.vNormal.xyz);
    float3 halfSpec = normalize(light + v.vViewer.xyz);
    Temp = float2(dot(normal, light), dot(normal, halfSpec));
    float4 LitCoef = lit(Temp.x, Temp.y, g_colors[2].a);
#else
    float3 normal = v.vNormal.xyz;
    float4 LitCoef = float4(1, dot(normal, light), 0, 0);
#endif//SPECULAR_ENABLED
    LitCoef.y = saturate(LitCoef.y + (g_ambientLight.r + g_ambientLight.g + g_ambientLight.b)/3);
    oColor.rgb =
                // ambient: 
                (g_colors[0].rgb + 0.2*v.vColorDif.rgb + 0.7*g_ambientLight.rgb)*g_ambientLight.rgb +
                // diffuse component:
                g_colors[1].rgb*v.vColorDif.rgb*g_lightColor.rgb*max(g_colors[3].a, LitCoef.y) + 
                // specular component:
                g_colors[2].rgb*LitCoef.z + 
                // emissive component:
                g_colors[3].rgb*g_colors[3].a;

#ifdef ALPHABLEND_ENABLED
    Temp.x = abs(dot(v.vViewer.xyz, normal));
    Temp.y = g_colors[1].a*ALPHABLEND_VERTEXCOLOR*g_alpha.y;
    if (g_alpha.w >= 0)
      Temp.x = lerp(1, Temp.x, g_alpha.w);
    else
      Temp.x = lerp(1, 1-Temp.x, abs(g_alpha.w));
    oColor.a = Temp.y*Temp.x*Temp.x*g_alpha.y;
#else
    oColor.a = g_alpha.y;
#endif//ALPHABLEND_ENABLED
#ifdef ALPHATEST_ENABLED
    clip(oColor.a - g_alpha.x);
#endif//ALPHATEST_ENABLED
    return oColor;
}
#endif //PIXEL_SHADER
