/***************************************************************************
 *                          Zanoza Modeler v3.x                            *
 *      This is unpublished propietary source code of Zanoza Software.     *
 *      The copyright notice does not evidence any actual or intended      *
 *                    publication of such source code.                     *
 *                                                                         *
 *                 Copyright (c) 2002-2012 Zanoza Software.                *
 *                                                                         *
 *                        All rights reserved.                             *
 ***************************************************************************
 *--------------------------------------------------------------------------
 * @author:   Oleg M.
 *--------------------------------------------------------------------------
 * @purpose:  ZModeler 3.x Color + Diffuse + DirtScratch Texture shader
 *--------------------------------------------------------------------------
 * @histroy: 23.08.2011. Created
<[[
UserName = "Diffuse+Dirt"
Description = "Color Diffuse and Dirt-Scratch map"
Version  = 1.1
Options  = SOLID SPECULAR
Samplers = DETAIL DIRTMUD
ManualUV1 = v.vUV01.xy
ManualUV2 = v.vUV01.zw
ManualUV3 = v.vUV23.xy
ManualUV4 = v.vUV23.zw
EnvUV = v.vUVRefl.xy
WorldUV = v.vUVRefl.zw
AlphaRegister = 21

[DETAIL]
Variable = g_Diffuse
Register = 0
Mask = R G B A RGB
Scale = 22.B
Level = 22.R
AngularLevel = 22.G

[DIRTMUD]
Variable = g_DirtMud
Register = 1
Mask = RGB
Scale = 23.B
Level = 23.R
AngularLevel = 23.G
	

[ALPHABLEND]

[ALPHATEST]

[CUSTOM.1]
Name = Dirt Mask
Slot = 24
Type = color
Default = (255, 0, 0)

[CUSTOM.2]
Name = Scratch Mask
Slot = 25
Type = color
Default = (0, 255, 0)

[CUSTOM.3]
Name = Dirt Color
Slot = 26
Type = color
Default = (60, 50, 20)

[CUSTOM.4]
Name = Scratch Color
Slot = 27
Type = color
Default = (120, 120, 120)

[CUSTOM.5]
Name = Dirt Level
Slot = 22.A
Type = float
Default = 0.8
Min = 0.0
Max = 1.0

[CUSTOM.6]
Name = Scrach Level
Slot = 23.A
Type = float
Default = 0.5
Min = 0.0
Max = 1.0

]]>
*/

#pragma pack_matrix( row_major ) 

struct VS_INPUT
{
    uint   vVmt             : TEXCOORD4;
    uint   vStatus          : TEXCOORD5;
    uint   vUserDefined     : TEXCOORD6;
    uint   vExtension       : TEXCOORD7;
    float4 vPosition        : POSITION;
    float4 vNormal          : NORMAL;
    float4 vTangent         : TANGENT;
    uint   vColorDif        : COLOR0;
    uint   vColorSpec       : COLOR1;
    float2 vUV0             : TEXCOORD0;
    float2 vUV1             : TEXCOORD1;
    float2 vUV2             : TEXCOORD2;
    float2 vUV3             : TEXCOORD3;
};

struct VS_OUTPUT
{
    float4 vPosition  : POSITION;   //transformed position
    float4 vColorDif  : COLOR0;
    //precomputed stuff:
    float4 vNormal    : TEXCOORD0;  //world-space normal;
    float4 vViewer    : TEXCOORD1;  //camera-space position;
    float4 vUV01      : TEXCOORD2;
    float4 vUV23      : TEXCOORD3;
    float4 vUVRefl    : TEXCOORD4;
};

//----------------------------------------------------------------------
// globals:
//----------------------------------------------------------------------
// c0-c3        : world-view-projection matrix;
// c4-c7        : world-view matrix;
// c8-c11       : world matrix;
//
// c12-c15       : ambient RGB, diffuse RGB + A:opacity, specular RGB + A:strength, emissive RGB + A:strength;
//----------------------------------------------------------------------
float4x4    g_mWorldViewProj : register(c0);
float4x4    g_mWorldView     : register(c4);
float4x4    g_mWorld         : register(c8);
float4      g_colors[4]      : register(c12);
float4      g_viewDirection  : register(c16);
float4      g_viewPosition   : register(c17);   //0,0,0,0 on non-perspective views;
float4      g_lightDir       : register(c18);
float4      g_lightColor     : register(c19);
float4      g_ambientLight   : register(c20);
float4      g_alpha          : register(c21);  //[minlevel:testvalue, maxlevel, mapaffect, angular level]
float4      g_textureAmp     : register(c22);  //[diff amp, diff angular, diff scale, Dirt level]
float4      g_dirtAmp        : register(c23);  //[dirt amp, dirt angular, dirt scale, Scratch level]
float4      g_dirtMask       : register(c24);
float4      g_scratchMask    : register(c25);
float4      g_dirtColor      : register(c26);
float4      g_scratchColor   : register(c27);


// textures:
sampler     g_Diffuse        : register(s[0]);
sampler     g_DirtMud        : register(s[1]);

#ifdef VERTEX_SHADER
VS_OUTPUT mainVS(in VS_INPUT v)
{
    VS_OUTPUT output = (VS_OUTPUT)0;

    output.vPosition = mul(v.vPosition, g_mWorldViewProj);
    output.vNormal = mul(float4(v.vNormal.xyz, 0), g_mWorld);
    output.vViewer = normalize(g_viewPosition - mul(v.vPosition, g_mWorld));
   
    output.vUV01 = float4(v.vUV0.xy, v.vUV1.xy);
    output.vUV23 = float4(v.vUV2.xy, v.vUV3.xy);
    output.vUVRefl.xy = (mul(float4(v.vNormal.xyz, 0), g_mWorldView).xy+1)/2;
    output.vUVRefl.zw = v.vPosition.xz;
    output.vColorDif = v.vColorDif;

    return output;
}
#endif //VERTEX_SHADER

#ifdef PIXEL_SHADER
//------------------------------------------------------------
//  PixelShader: generic Dif+Bump+SpecMap+Refl;
//------------------------------------------------------------
float4 mainPS(in VS_OUTPUT v) : COLOR0
{
    float4 oColor;
    float4 CONST_TEXEL   = float4(1,1,1,1);
    float4 VCOLOR_TEXEL  = v.vColorDif;
    float4 DETAIL_TEXEL  = tex2D(DETAIL_SOURCE, DETAIL_UV_SOURCE*g_textureAmp.z);
    float4 DIRTMUD_TEXEL = tex2D(DIRTMUD_SOURCE, DIRTMUD_UV_SOURCE*g_dirtAmp.z);

    float3 light = -g_lightDir.xyz;
    float4 Temp   = float4(1,1,saturate(dot(v.vViewer.xyz, v.vNormal.xyz)), 0); 
    
#ifdef SPECULAR_ENABLED
    float3 normal = normalize(v.vNormal.xyz);
    float3 halfSpec = normalize(light + v.vViewer.xyz);
    Temp.xy = float2(dot(normal, light), dot(normal, halfSpec));
    float4 LitCoef = lit(Temp.x, Temp.y, g_colors[2].a);
#else
    float4 LitCoef = float4(1, saturate(dot(light, v.vNormal.xyz)), 0, 0);
#endif //SPECULAR_ENABLED
    LitCoef.y = saturate(LitCoef.y + (g_ambientLight.r + g_ambientLight.g + g_ambientLight.b)/3);

    float3 fDiffuseColor    = (DETAIL_INPUT)DETAIL_MASK;
    if (g_textureAmp.y >= 0)
      Temp.w = lerp(1, Temp.z, g_textureAmp.y)*g_textureAmp.x;
    else
      Temp.w = lerp(1, 1-Temp.z, abs(g_textureAmp.y))*g_textureAmp.x;

    float3 fDirtColor = dot((DIRTMUD_INPUT*DIRTMUD_INPUT_MASK).rgb, g_dirtMask.rgb)*g_textureAmp.w;
    float3 fScratchColor = dot((DIRTMUD_INPUT*DIRTMUD_INPUT_MASK).rgb, g_scratchMask.rgb)*g_dirtAmp.w;

    oColor.rgb =
                // ambient: 
                (g_colors[0].rgb + 0.2*v.vColorDif.rgb + 0.8*fDiffuseColor*g_ambientLight.rgb)*g_ambientLight.rgb +
                // diffuse component + specular + emissive VS dirt:
                lerp(g_colors[1].rgb*lerp(1, fDiffuseColor, Temp.w*(DETAIL_INPUT_MASK))*max(g_colors[3].a, LitCoef.y) +
                     g_colors[2].rgb*saturate(LitCoef.z) +
                     g_colors[3].rgb*g_colors[3].a,

                     (fDirtColor*g_dirtColor + fScratchColor*g_scratchColor)*LitCoef.y,
                     saturate(length(fDirtColor+fScratchColor)*g_dirtAmp.x));

#ifdef ALPHABLEND_ENABLED
    if (g_alpha.w >= 0)
      Temp.w = lerp(1, Temp.z, g_alpha.w);
    else
      Temp.w = lerp(1, 1-Temp.z, abs(g_alpha.w));
    oColor.a = g_colors[1].a*lerp(1, ALPHABLEND_INPUT, g_alpha.z)*ALPHABLEND_VERTEXCOLOR*Temp.w*Temp.w;
#else
    oColor.a = 1;
#endif//ALPHABLEND_ENABLED
#ifdef ALPHATEST_ENABLED
    clip(oColor.a - g_alpha.x);
#endif//ALPHATEST_ENABLED
    return oColor;
}
#endif //PIXEL_SHADER

