/***************************************************************************
 *                          Zanoza Modeler v3.x                            *
 *      This is unpublished propietary source code of Zanoza Software.     *
 *      The copyright notice does not evidence any actual or intended      *
 *                    publication of such source code.                     *
 *                                                                         *
 *                 Copyright (c) 2002-2012 Zanoza Software.                *
 *                                                                         *
 *                        All rights reserved.                             *
 ***************************************************************************
 *--------------------------------------------------------------------------
 * @author:   Oleg M.
 *--------------------------------------------------------------------------
 * @purpose:  ZModeler 3.x shader technique: solid for primitives
 *--------------------------------------------------------------------------
 * @histroy: 31.07.2012. Created

<[[
UserName = "Solid Color only"
Options  = PURE
Version  = 1.1
]]>

 */

#pragma pack_matrix( row_major ) 

struct VS_INPUT
{
    float4 vPosition        : POSITION;
    float4 vNormal          : NORMAL;
    float4 vColorDif        : COLOR0;
    float4 vDeformPosition  : TEXCOORD5;
    float4 vDeformNormal    : COLOR2;
    uint4  vBones           : BLENDINDICES;
    float4 vWeights         : BLENDWEIGHT;
};

struct VS_OUTPUT
{
    float4  vPosition : POSITION;
    float4  vDiffuse  : COLOR;
};


#include "zmCommon.inl"

#ifdef VERTEX_SHADER
VS_OUTPUT mainVS(in VS_INPUT v)
{
    VS_OUTPUT output;
    //transform to screen:
    float4 vNormal  = v.vNormal;
    float4 vTangent = (float4)0;
    float4 vView    = (float4)0;

    output.vPosition = transformInput(v, vNormal, vTangent, vView);

    //compute color:

    //diffuse:
    float4 color = g_colors[1]*(any(v.vColorDif.rgb) ? v.vColorDif : 1);

    //dim on diffuse light:
    float3 normal = normalize(vNormal.xyz);
    color.rgb = (g_colors[0].rgb + 0.2*v.vColorDif.rgb + 0.2*g_ambientLight.rgb)*g_ambientLight.rgb +
                color.rgb*dot(-g_lightDir.xyz, normal) + 
                g_colors[3].rgb*g_colors[3].a;

    output.vDiffuse.rgb = color;
    output.vDiffuse.a = g_colors[1].a * v.vColorDif.a;
    return output;
}
#endif //VERTEX_SHADER

float4 mainPS(in VS_OUTPUT v) : COLOR
{
  return v.vDiffuse;
}
