/***************************************************************************
 *                          Zanoza Modeler v3.x                            *
 *      This is unpublished propietary source code of Zanoza Software.     *
 *      The copyright notice does not evidence any actual or intended      *
 *                    publication of such source code.                     *
 *                                                                         *
 *                 Copyright (c) 2002-2012 Zanoza Software.                *
 *                                                                         *
 *                        All rights reserved.                             *
 ***************************************************************************
 *--------------------------------------------------------------------------
 * @author:   Oleg M.
 *--------------------------------------------------------------------------
 * @purpose:  ZModeler 3.x shaders common constants and routines
 *--------------------------------------------------------------------------
 * @histroy: 12.09.2011. Created
<[[
Version  = 1.1
]]>
 */
#ifndef ANIM_PALETTE_SIZE
#define ANIM_PALETTE_SIZE     100
#endif

//----------------------------------------------------------------------
// common set of globals constants:
//----------------------------------------------------------------------
// c0-c3        : world;
// c4-c7        : view matrix;
// c8-c11       : projection matrix;
// c12-c15      : world-view-projection matrix;
//
// c12-c15       : ambient RGB, diffuse RGB + A:opacity, specular RGB + A:strength, emissive RGB + A:strength;
//----------------------------------------------------------------------
float4x4    g_mWorld         : register(c0);
float4x4    g_mView          : register(c4);
float4x4    g_mProj          : register(c8);
float4x4    g_mWorldViewProj : register(c12);
float4      g_colors[4]      : register(c16);
float4      g_viewDirection  : register(c20);
float4      g_viewPosition   : register(c21);   //*,*,*,0 on non-perspective views;
float4      g_lightDir       : register(c22);
float4      g_lightColor     : register(c23);
float4      g_ambientLight   : register(c24);
float4      g_fog            : register(c25);   //[r,g,b, distance to 100% level or 0 to disable;]
float4      g_deform         : register(c26);   //[deform level, transform level, unused, unused]
float2x4    g_animQuat[ANIM_PALETTE_SIZE] : register(c55);  //dual-quad animation palette for upto 100 entries;

#ifdef VERTEX_SHADER
//
// converts dual quaterion to transformation matrix;
//
float4x4 matrixFromDualQuat(float2x4 dual)
{
  float4x4 m ;
  float length = dot(dual[0], dual[0]);
  float x = dual[0].x, y = dual[0].y, z = dual[0].z, w = dual[0].w;
  float t1 = dual[1].x, t2 = dual[1].y, t3 = dual[1].z, t0 = dual[1].w;

  float4x4 mTransform = {  //row 0
                           w*w + x*x - y*y - z*z,
                           2*x*y + 2*w*z,
                           2*x*z - 2*w*y,
                           0,
                           //row 1
                           2*x*y - 2*w*z,
                           w*w + y*y - x*x - z*z,
                           2*y*z + 2*w*x,
                           0,
                           //row 2
                           2*x*z + 2*w*y,
                           2*y*z - 2*w*x,
                           w*w + z*z - x*x - y*y,
                           0,
                           //row 3
                           -2*t0*x + 2*t1*w - 2*t2*z + 2*t3*y,
                           -2*t0*y + 2*t1*z + 2*t2*w - 2*t3*x,
                           -2*t0*z - 2*t1*y + 2*t2*x + 2*t3*w, 
                           1};
     
    
  return mTransform/length;
}
//
// common vertex transformation function. 
// respects deformation and transformation tweening;
//

float4 transformInput(in VS_INPUT v, inout float4 vNorm, inout float4 vTangent, inout float4 vView) : POSITION
{
  float4x4 mTransform = (float4x4)0;
  if (g_deform.y > 0.01)
  {
    float2x4 finalDualquat = (float2x4)0;
    float2x4 m;
    finalDualquat[0].w = 1;
    finalDualquat[1].w = 1;
    float4 weights = {v.vWeights.x*g_deform.y, v.vWeights.y*g_deform.y, v.vWeights.z*g_deform.y, 
                      (1 - v.vWeights.x - v.vWeights.y - v.vWeights.z)*g_deform.y};

    m = g_animQuat[v.vBones.x];
    float4 dq0 = (float1x4)m;

    finalDualquat = weights.x*m;

    m = g_animQuat[v.vBones.y];
    float4 dq = (float1x4)m;
    if (dot(dq0, dq) < 0)
      finalDualquat -= weights.y*m;
    else
      finalDualquat += weights.y*m;

    m = g_animQuat[v.vBones.z];
    dq = (float1x4)m;
    if (dot(dq0, dq) < 0)
      finalDualquat -= weights.z*m;
    else
      finalDualquat += weights.z*m;


    m = g_animQuat[v.vBones.w];
    dq = (float1x4)m;
    if (dot(dq0, dq) < 0)
      finalDualquat -= weights.w*m;
    else
      finalDualquat += weights.w*m;

    mTransform = matrixFromDualQuat(finalDualquat);
  }
  else
    mTransform[0][0] = mTransform[1][1] = mTransform[2][2] = mTransform[3][3] = 1;
    

  // [optionally] deformed position:
  float4 vPosDef = v.vPosition + g_deform.x*float4(v.vDeformPosition.xyz,0);
  // [optionally] transformed position:
  vPosDef = float4(mul(float4(mul(vPosDef, (float4x3)mTransform),1), (float4x3)g_mWorld),1);
  //vPosDef = float4(mul(float4(mul(vPosDef, (float4x3)g_mWorld),1), (float4x3)mTransform),1);

  vView = normalize(g_viewPosition - vPosDef);
  // position in camera space:
  vPosDef = float4(mul(vPosDef, (float4x3)g_mView),1);
  // position on screen:
  vPosDef = mul(vPosDef, g_mProj);

  // [optionally] deformed normal:
  vNorm = vNorm + g_deform.x*float4(v.vDeformNormal.xyz*4-(float3)(2,2,2), 0);
  // transformed normal:
  vNorm.xyz = mul(mul(vNorm.xyz, (float3x3)mTransform), (float3x3)g_mWorld);
  //vNorm.xyz = mul(mul(vNorm.xyz, (float3x3)g_mWorld), (float3x3)mTransform);
  // transformed tangent:
  vTangent.xyz = mul(mul(vTangent.xyz, (float3x3)mTransform), (float3x3)g_mWorld);

  return vPosDef;
}

#endif //VERTEX_SHADER
