#pragma once
#include "CodeInjector.h"
#include "GameVersionManager.h"
#include "CrtFix.h"
#include "DmaFix.h"
#include "MenuStatusNotifier.h"
#include "ScriptEngine.h"
#include "CustomOpcodeSystem.h"
#include "TextManager.h"
#include "SoundSystem.h"
#include "PluginSystem.h"

namespace CLEO
{
	// This is the root class of CLEO library. It controls 
	// all other library systems
	class CleoInstance
	{
		bool started;
	public:
		CleoInstance(void);
		virtual ~CleoInstance(void);
		void start();
		void stop();
	public:
		// CLEO subsystems
		CodeInjector codeInjector;
		GameVersionManager versionManager;
		CrtFix crtFix;
		DmaFix dmaFix;
		MenuStatusNotifier menuStatusNotifier;
		ScriptEngine scriptEngine;
		CustomOpcodeSystem opcodeSystem;
		TextManager textManager;
		SoundSystem soundSystem;
		PluginSystem pluginSystem;
	};

	CleoInstance& GetThisInstance();
}
