#pragma once
#include <cstdint>
#include <cstdint>
#include <algorithm>
#include <windows.h>
#include <mutex>
#include "DebugLog.h"

#undef CDECL
#undef STDCALL
#undef THISCALL
#undef FASTCALL
#undef MS_FASTCALL
#undef BORLAND_FASTCALL
#undef NAKED
#ifndef __GNUC__
#error Unsupported compiler
#define CDECL
#define STDCALL
#define THISCALL
#define FASTCALL
#define MS_FASTCALL
#define BORLAND_FASTCALL
#define REVERSED
#else
// MSVC calling conventions
#define CDECL __attribute__((cdecl, /* ms_abi */))
#define STDCALL __attribute__((stdcall, /* ms_abi */))
#define THISCALL __attribute__((thiscall, /* ms_abi */))
#define FASTCALL __attribute__((fastcall, /* ms_abi */))
#define MS_FASTCALL FASTCALL
// first 3 parameters are passed in registers EAX, EDX, ECX
#define BORLAND_FASTCALL __attribute__((regparm(3)))
// functions with no prologue/epilogue
// reversed structures attribute
#define REVERSED __attribute__((aligned(4), packed, /*ms_struct*/))
#endif
#define VALIDATE_SIZE(struc, size) static_assert(sizeof(struc) == size, "Invalid structure size " #struc)

namespace CLEO
{	
	// a pointer automatically convertible to integral types
	union memory_pointer
	{
		size_t address;
		void *pointer;

		inline memory_pointer(void *p) : pointer(p) { }
		inline memory_pointer(size_t a) : address(a) { }
		inline operator void *() { return pointer; }
		inline operator size_t() { return address; }
		inline memory_pointer& operator=(void *p) { return *this = p; }
		inline memory_pointer& operator=(size_t p) { return *this = p; }

		// conversion to/from any-type pointer
		template<typename T> inline memory_pointer(T *p) : 
			pointer(reinterpret_cast<void *>(p)) { }
		template<typename T> inline operator T *() 
			{ return reinterpret_cast<T *>(pointer); }
		template<typename T> inline operator const T *() const 
			{ return reinterpret_cast<const T *>(pointer); }
		template<typename T> inline memory_pointer& operator=(T *p) 
			{ return *this = reinterpret_cast<void *>(p); }
	};

	VALIDATE_SIZE(memory_pointer, 4);

	const memory_pointer memory_und = nullptr;
	
	// Implements dirty tricks for low-level memory managemant
	class CodeInjector
	{
		bool access_opened;
		std::mutex mut;
	public:
		CodeInjector(void);
		~CodeInjector(void);
		void OpenReadWriteAccess();
		void CloseReadWriteAccess();
		template<typename FunctionType>
		void ReplaceFunction(FunctionType *funcPtr, memory_pointer Position)
		{
			std::lock_guard<decltype(mut)> lock(mut);
			DWORD flProtect;
			void *address = Position;
			TRACE("Replacing function call at position: 0x%08X", (unsigned int)Position);
			if (!access_opened)
				VirtualProtect(Position, 5, PAGE_EXECUTE_READWRITE, &flProtect);
			*(BYTE *)address = 0xE8;	// CALL
			*(DWORD *)((BYTE *)address + 1) = (DWORD)funcPtr - ((DWORD)address + 5);
			if (!access_opened)
				VirtualProtect(Position, 5, flProtect, &flProtect);
		}

		template<typename FunctionType>
		void InjectFunction(FunctionType *funcPtr, memory_pointer Position)
		{
			std::lock_guard<decltype(mut)> lock(mut);
			DWORD flProtect;
			void *address = Position;
			TRACE("Injecting function at position: 0x%08X", (unsigned int)Position);
			if (!access_opened)
				VirtualProtect(Position, 5, PAGE_EXECUTE_READWRITE, &flProtect);
			*(BYTE *)address = 0xE9;	// JMP
			*(DWORD *)((BYTE *)address + 1) = (DWORD)funcPtr - ((DWORD)address + 5);
			if (!access_opened)
				VirtualProtect(Position, 5, flProtect, &flProtect);
		}

		void Nop(memory_pointer addr, size_t size);

		// copies object given by memory address @addr to the @result object
		template<typename T> void MemoryRead(memory_pointer addr, T& result, bool force_vp = false)
		{
			DWORD oldProtect; T *p = addr; 
			bool vp = force_vp;
			if (vp) VirtualProtect(p, sizeof(T), PAGE_EXECUTE_READWRITE, &oldProtect);
			result = *p;
			if (vp) VirtualProtect(p, sizeof(T), oldProtect, &oldProtect);
		}
		
		// copies array of objects given by memory address @addr to the @result array of length @cnt
		template<typename T> void MemoryRead(memory_pointer addr, T *result, size_t cnt, bool force_vp = false)
		{
			DWORD oldProtect; T *p = addr; 
			bool vp = force_vp;
			if (vp) VirtualProtect(p, sizeof(T) * cnt, PAGE_EXECUTE_READWRITE, &oldProtect);
			std::copy(p, p + cnt, result);
			if (vp) VirtualProtect(p, sizeof(T) * cnt, oldProtect, &oldProtect);
		}

		// copies @proto object to the object given by memory address @addr
		template<typename T> void MemoryWrite(memory_pointer addr, const T& proto, bool force_vp = false, size_t fill_cnt = 1)
		{
			DWORD oldProtect; T *p = addr; 
			bool vp = force_vp || !access_opened;
			if (vp) VirtualProtect(p, sizeof(T) * fill_cnt, PAGE_EXECUTE_READWRITE, &oldProtect);
			std::fill(p, p + fill_cnt, proto);
			if (vp) VirtualProtect(p, sizeof(T) * fill_cnt, oldProtect, &oldProtect);
		}

		// copies array of objects @proto of length @cnt to array of objects given by memory address @addr
		template<typename T> void MemoryWrite(memory_pointer addr, const T *proto, size_t cnt, bool force_vp = false)
		{
			DWORD oldProtect; T *p = addr;
			bool vp = force_vp || !access_opened;
			if (vp) VirtualProtect(p, sizeof(T) * cnt, PAGE_EXECUTE_READWRITE, &oldProtect);
			std::copy(proto, proto + cnt, p);
			if (vp) VirtualProtect(p, sizeof(T) * cnt, oldProtect, &oldProtect);
		}
	};

	// determines an object, that should be injected into the game engine
	// on startup
	class iInjectible
	{
	public:
		virtual void inject(CodeInjector& inj) = 0;
	};
}
