#include "CrtFix.h"
#include "CleoInstance.h"
#include "GameVersionManager.h"
#include <cstdio>

namespace CLEO
{
	void CrtFix::inject(CodeInjector& inj)
	{
		TRACE("Injecting CrtFix...");
		GameVersionManager& gvm = GetThisInstance().versionManager;
		inj.InjectFunction(fopen,	gvm.TranslateMemoryAddress(MA_FOPEN_FUNCTION));
		inj.InjectFunction(fclose,	gvm.TranslateMemoryAddress(MA_FCLOSE_FUNCTION));
		inj.InjectFunction(fgetc,	gvm.TranslateMemoryAddress(MA_FGETC_FUNCTION));
		inj.InjectFunction(fgets,	gvm.TranslateMemoryAddress(MA_FGETS_FUNCTION));
		inj.InjectFunction(fputs,	gvm.TranslateMemoryAddress(MA_FPUTS_FUNCTION));
		inj.InjectFunction(fread,	gvm.TranslateMemoryAddress(MA_FREAD_FUNCTION));
		inj.InjectFunction(fwrite,	gvm.TranslateMemoryAddress(MA_FWRITE_FUNCTION));
		inj.InjectFunction(fseek,	gvm.TranslateMemoryAddress(MA_FSEEK_FUNCTION));
		inj.InjectFunction(fprintf,	gvm.TranslateMemoryAddress(MA_FPRINTF_FUNCTION));
		inj.InjectFunction(ftell,	gvm.TranslateMemoryAddress(MA_FTELL_FUNCTION));
		inj.InjectFunction(fflush,	gvm.TranslateMemoryAddress(MA_FFLUSH_FUNCTION));
		inj.InjectFunction(feof,	gvm.TranslateMemoryAddress(MA_FEOF_FUNCTION));
		inj.InjectFunction(ferror,	gvm.TranslateMemoryAddress(MA_FERROR_FUNCTION));
	}
}
