#pragma once
#include <cstdio>
#include <fstream>

class DebugLog
{
#ifndef _NTRACE
	std::ofstream m_File;
#endif
public:
	DebugLog(void);
	~DebugLog(void);
	void trace(const char *fmt, ...) __attribute__ ((format(printf, 2, 3)));
};

extern DebugLog debug;

#ifndef _NTRACE
#define TRACE(...) { debug.trace(__VA_ARGS__); }
#else
#define TRACE(...) static_cast<void>(0);
#endif

void Error(const char *message) __attribute__((noreturn));
void Warning(const char *message);