#include "DmaFix.h"
#include "GameVersionManager.h"
#include "CleoInstance.h"

namespace CLEO
{
	void DmaFix::inject(CodeInjector& inj)
	{
		TRACE("Injecting DmaFix...");
		GameVersionManager& gvm = GetThisInstance().versionManager;
		switch (gvm.GetGameVersion())
		{
		case GV_EU10:
		case GV_US10:
			inj.MemoryWrite(0x463CC5, (DWORD)0x0824448B);
			inj.MemoryWrite(0x463CC9, (BYTE)0x90);

			inj.Nop(0x4641C6, 3);
			inj.Nop(0x4641E8, 3);
			inj.Nop(0x4641FE, 3);

			inj.Nop(0x46447F, 3);
			inj.Nop(0x4644A1, 3);
			inj.Nop(0x4644B7, 3);
			break;
		case GV_EU11:
			inj.MemoryWrite(0x463D45, (DWORD)0x0824448B);
			inj.MemoryWrite(0x463D49, (BYTE)0x90);

			inj.Nop(0x464246, 3);
			inj.Nop(0x464268, 3);
			inj.Nop(0x46427E, 3);

			inj.Nop(0x4644FF, 3);
			inj.Nop(0x464521, 3);
			inj.Nop(0x464537, 3);
			break;
		default:
			Error("DmaFix::inject(): Unimplemented game version.");
		}
	}
}