#pragma once
#include <windows.h>

template<typename functor_type>
void enumerate_files(const char *file_mask, functor_type func)
{
	HANDLE hSearch = NULL;
	WIN32_FIND_DATA wfd;
	memset(&wfd, 0, sizeof(WIN32_FIND_DATA));
	if ((hSearch = FindFirstFile(file_mask, &wfd)) == INVALID_HANDLE_VALUE) 
		return;
	do if (!(wfd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)) func(wfd.cFileName);
	while (FindNextFile(hSearch, &wfd));
	FindClose (hSearch);
}
