#pragma once
#include "COdeInjector.h"
#include "RwV3d.h"

struct REVERSED CHandlingBoat
{
	DWORD		ID;							// 0000
	DWORD		thrustY;					// 0004
	DWORD		thrustZ;					// 0008
	DWORD		thrustAppZ;					// 000C
	DWORD		aqPlaneForce;				// 0010
	DWORD		aqPlaneLimit;				// 0014
	DWORD		aqPlaneOffset;				// 0018
	DWORD		waveAudioMult;				// 001C
	DWORD		look_L_R_BehindCamHeight;	// 0020
	RwV3d		moveRes;					// 0024
	RwV3d		turnRes;					// 0030
};

VALIDATE_SIZE(CHandlingBoat, 0x3C);

struct REVERSED CHandlingBike
{
	DWORD		ID;							// 0000
	DWORD		leanFwdCOM;					// 0004
	DWORD		leanFwdForce;				// 0008
	DWORD		leanBakCOM;					// 000C
	DWORD		leanBakForce;				// 0010
	DWORD		maxLean;					// 0014
	DWORD		fullAnimLean;				// 0018
	DWORD		desLean;					// 001C
	DWORD		speedSteer;					// 0020
	DWORD		slipSteer;					// 0024
	DWORD		noPlayerCOMz;				// 0028
	DWORD		wheelieAng;					// 002C
	DWORD		stoppieAng;					// 0030
	DWORD		wheelieSteer;				// 0034
	DWORD		wheelieStabMult;			// 0038
	DWORD		stoppieStabMult;			// 003C
};

VALIDATE_SIZE(CHandlingBike, 0x40);

struct REVERSED CHandlingFlying
{
	DWORD		index;			// 0000
	DWORD		thrustFallOff;	// 0004
	DWORD		thrust;			// 0008
	DWORD		YawStab;		// 000C
	DWORD		Yaw;			// 0010
	DWORD		Roll;			// 0014
	DWORD		SideSlip;		// 0018
	DWORD		Pitch;			// 001C
	DWORD		RollStab;		// 0020
	DWORD		FormLift;		// 0024
	DWORD		PitchStab;		// 0028
	DWORD		GearUpR;		// 002C
	DWORD		AttackLift;		// 0030
	DWORD		WindMult;		// 0034
	DWORD		GearDownL;		// 0038
	DWORD		MoveRes;		// 003C
	RwV3d		turnRes;		// 0040
	RwV3d		speedRes;		// 004C
};

VALIDATE_SIZE(CHandlingFlying, 0x58);

struct REVERSED CTransmissionData
{
	DWORD					field_0;		// 0000
	DWORD					field_4;		// 0004
	DWORD					field_8;		// 0008
	DWORD					field_C;		// 000C
	DWORD					field_10;		// 0010
	DWORD					field_14;		// 0014
	DWORD					field_18;		// 0018
	DWORD					field_1C;		// 001C
	DWORD					field_20;		// 0020
	DWORD					field_24;		// 0024
	DWORD					field_28;		// 0028
	DWORD					field_2C;		// 002C
	DWORD					field_30;		// 0030
	DWORD					field_34;		// 0034
	DWORD					field_38;		// 0038
	DWORD					field_3C;		// 003C
	DWORD					field_40;		// 0040
	DWORD					field_44;		// 0044
	BYTE					nDriveType;		// 0048
	BYTE					nEngineType;		// 0049
	BYTE					nNumberOfGears;		// 004A
	BYTE					field_4B;		// 004B
	DWORD					field_4C;		// 004C
	DWORD					fEngineAcceleration;		// 0050
	DWORD					fEngineInertia;		// 0054
	DWORD					fMaxVelocity;		// 0058
	DWORD					field_5C;		// 005C
	DWORD					field_60;		// 0060
};

VALIDATE_SIZE(CTransmissionData, 0x64);

struct REVERSED CHandlingAutomobile
{
	DWORD					index;			// 0000
	DWORD					fMass;			// 0004 
	DWORD					field_8;		// 0008 // (1/fMass)
	DWORD					fTurnMass;		// 000C
	DWORD					fDragMult;		// 0010
	RwV3d					centreOfMass;	// 0014
	BYTE					nPercentSubmerged;		// 0020
	BYTE					field_21;		// 0021
	BYTE					field_22;		// 0022
	BYTE					field_23;		// 0023
	DWORD					normalizedGrip;		// 0024 //(fMass*0.8/(float)nPercentSubmerged)
	DWORD					fTractionMultiplier;		// 0028
	CTransmissionData		transmissionData;		// 002C
	DWORD					field_90;		// 0090
	DWORD					fBrakeDeceleration;		// 0094
	DWORD					fBrakeBias;		// 0098
	BYTE					bABS;		// 009C
	BYTE					field_9D;		// 009D
	BYTE					field_9E;		// 009E
	BYTE					field_9F;		// 009F
	DWORD					fSteeringLock;		// 00A0
	DWORD					fTractionLoss;		// 00A4
	DWORD					fTractionBias;		// 00A8
	DWORD					fSuspensionForceLevel;		// 00AC
	DWORD					fSuspensionDampingLevel;		// 00B0
	DWORD					fSuspensionHighSpdComDamp;		// 00B4
	DWORD					fSuspensionUpperLimit;		// 00B8
	DWORD					fSuspensionLowerLimit;		// 00BC
	DWORD					fSuspensionBiasBetweenFrontAndRear;		// 00C0
	DWORD					fSuspensionAntiDiveMultiplier;		// 00C4
	DWORD					fCollisionDamageMultiplier;		// 00C8
	DWORD					modelFlags;		// 00CC
	DWORD					handlingFlags;		// 00D0
	DWORD					fSeatOffsetDistance;		// 00D4
	DWORD					nMonetaryValue;		// 00D8
	BYTE					frontLight;		// 00DC
	BYTE					rearLight;		// 00DD
	BYTE					animGroup;		// 00DE
	BYTE					field_DF;		// 00DF
};

VALIDATE_SIZE(CHandlingAutomobile, 0xE0);

struct REVERSED CHandling
{
	DWORD					field_0;				// 0000
	DWORD					field_4;				// 0004
	DWORD					field_8;				// 0008
	DWORD					field_C;				// 000C
	DWORD					field_10;				// 0010
	CHandlingAutomobile		autoHandling[0xD2];		// 0014
	CHandlingBike			bikeHandling[0xD];		// B7D4
	CHandlingFlying			flyingHandling[0x18];	// BB14
	CHandlingBoat			boatHandling[0xC];		// C354
};

VALIDATE_SIZE(CHandling, 0xC624);
