#pragma once
#include <cstdint>
#include "CodeInjector.h"

// forward declarations
class CPed; class CVehicle; class CObject;

template<typename T, size_t elem_size = sizeof(T)>
struct REVERSED CPool
{
	void	*objects;
	BYTE	*flags;
	size_t	size;
	int		top;
	bool	initialized;
	BYTE	__pad;
	WORD	objectSize;	

	inline T *atHandle(size_t handle)
	{
		size_t index = handle >> 8;
		BYTE flags = (BYTE)handle;
		if (this->flags[index] == flags)
			return (T *)((ptrdiff_t)objects + index * elem_size);
		else
			return nullptr;
	}

	inline size_t handleOf(T *obj)
	{
		size_t index = ((size_t)obj - (size_t)objects) / elem_size;
		return (index << 8) | flags[index];
	}
	
	inline T& operator[](size_t index) { return *(T *)((ptrdiff_t)objects + index * elem_size); }
	inline const T& operator[](size_t index) const { return *(T *)((ptrdiff_t)objects + index * elem_size); }
};

typedef CPool<CPed, 0x7C4> CPedPool;
typedef CPool<CVehicle, 0xA18> CVehiclePool;
typedef CPool<CObject, 0x19C> CObjectPool;

namespace CLEO
{
	extern CPedPool			**pedPool;
	extern CVehiclePool		**vehiclePool;
	extern CObjectPool		**objectPool;
}

VALIDATE_SIZE(CPool<int>, 0x14);
