#pragma once
#include "CodeInjector.h"
#include <algorithm>

union SCRIPT_VAR 
{
	unsigned	dwParam;
	int			nParam;
	float		fParam;
	void		*pParam;
	char		*szParam;
};

struct REVERSED CScriptThread
{
	CScriptThread	*next;
	CScriptThread	*prev;
	char			threadName[8];
	BYTE			*baseIp;
	BYTE			*ip;			
	BYTE			*gosub_stack[8];
	WORD			stack_index;
	WORD			_f3A;
	SCRIPT_VAR		tls[32];	
	DWORD			timers[2];	
	bool			isActive;
	bool			condResult;	
	bool			MissionCleanUpFlag;
	bool			IsExternalThread;
	BYTE			_fC8;
	char			_fC9;
	BYTE			_fCA;
	BYTE			_fCB;
	DWORD			wakeTime;
	WORD			logicalOp;
	bool			notFlag;
	bool			wastedBustedCheckEnabled;
	bool			wastedOrBusted;
	BYTE			_fD5;
	WORD			_fD6;
	DWORD			sceneSkipOffset;
	bool			missionFlag;
	// bellow is align in 4 bytes
	WORD			scmFunction;
	BYTE			IsCustom;
protected:
	CScriptThread() :
		next(nullptr), prev(nullptr), baseIp(nullptr), ip(nullptr), stack_index(0),
		isActive(false), condResult(false), MissionCleanUpFlag(false),
		IsExternalThread(false), _fC8(0), _fC9(-1), wakeTime(0), logicalOp(0), 
		notFlag(false),	wastedBustedCheckEnabled(true), 
		wastedOrBusted(false), sceneSkipOffset(0), missionFlag(false), scmFunction(-1),
		IsCustom(0)
	{
		std::fill(threadName, threadName + sizeof(threadName), '\0');
		std::fill(gosub_stack, gosub_stack + sizeof(gosub_stack), nullptr);
		for (SCRIPT_VAR& var : tls) var.dwParam = 0;			// clear variables
		timers[0] = timers[1] = 0;								// clear timers
	}
};

VALIDATE_SIZE(CScriptThread, 0xE0);
