#include "GameVersionManager.h"
#include <windows.h>

namespace CLEO
{
	GameVersion determineGameVersion()
	{
		return (*(DWORD*)0x8A6168 == 0x8523A0)? GV_EU11:	//1.01 eu
			(*(DWORD*)0x8A4004 == 0x8339CA)? GV_US10:		//1.0 us
			(*(DWORD*)0x8A4004 == 0x833A0A)? GV_EU10:		//1.0 eu
			GV_UNK;											//other
	}

	GameVersionManager::GameVersionManager(void)
		: m_gv(determineGameVersion())
	{
	}


	GameVersionManager::~GameVersionManager(void)
	{
	}

	GameVersion GameVersionManager::GetGameVersion()
	{
		return m_gv;
	}

	memory_pointer MemoryAddresses[MA_TOTAL][GV_TOTAL] = 
	{
		{ 0x0053E981, memory_und, 0x0053E981, 0x0053EE21, },		// MA_CALL_UPDATE_GAME_LOGICS,
		{ 0x0053BEE0, memory_und, 0x0053BEE0, 0x0053C380, },		// MA_UPDATE_GAME_LOGICS_FUNCTION,

		{ 0x008232D8, memory_und, 0x00823318, 0x00824098, },		// MA_FOPEN_FUNCTION,
		{ 0x0082318B, memory_und, 0x008231CB, 0x00823F4B, },		// MA_FCLOSE_FUNCTION,
		{ 0x008231DC, memory_und, 0x0082321C, 0x00823F9C, },		// MA_FGETC_FUNCTION,
		{ 0x00823798, memory_und, 0x008237D8, 0x00824558, },		// MA_FGETS_FUNCTION,
		{ 0x008262B8, memory_und, 0x008262F8, 0x00826BA8, },		// MA_FPUTS_FUNCTION,
		{ 0x00823521, memory_und, 0x00823561, 0x008242E1, },		// MA_FREAD_FUNCTION,
		{ 0x00823674, memory_und, 0x008236B4, 0x00824434, },		// MA_FWRITE_FUNCTION,
		{ 0x0082374F, memory_und, 0x0082378F, 0x0082450F, },		// MA_FSEEK_FUNCTION,
		{ 0x00823A30, memory_und, 0x00823A70, 0x008247F0, },		// MA_FPRINTF_FUNCTION,
		{ 0x00826261, memory_und, 0x008262A1, 0x00826B51, },		// MA_FTELL_FUNCTION,
		{ 0x00823E86, memory_und, 0x00823EC6, 0x00824C46, },		// MA_FFLUSH_FUNCTION,
		{ 0x008262A2, memory_und, 0x008262E2, 0x00826B92, },		// MA_FEOF_FUNCTION,
		{ 0x008262AD, memory_und, 0x008262ED, 0x00826B9D, },		// MA_FERROR_FUNCTION,

		{ 0x00BA6748, memory_und, 0x00BA6748, 0x00BA8DC8, },		// MA_MENU_MANAGER,
		{ 0x0071A700, memory_und, 0x0071A700, 0x0071AF30, },		// MA_DRAW_TEXT_FUNCTION,
		{ 0x00719610, memory_und, 0x00719610, 0x00719E40, },		// MA_SET_TEXT_ALIGN_FUNCTION,
		{ 0x00719490, memory_und, 0x00719490, 0x00719CC0, },		// MA_SET_TEXT_FONT_FUNCTION,
		{ 0x005733E0, memory_und, 0x005733E0, 0x00573950, },		// MA_CMENU_SCALE_X_FUNCTION,
		{ 0x00573410, memory_und, 0x00573410, 0x00573980, },		// MA_CMENU_SCALE_Y_FUNCTION,
		{ 0x00719380, memory_und, 0x00719380, 0x00719BB0, },		// MA_SET_LETTER_SIZE_FUNCTION,
		{ 0x00719430, memory_und, 0x00719430, 0x00719C60, },		// MA_SET_LETTER_COLOR_FUNCTION,
		{ 0x00728350, memory_und, 0x00728350, 0x00728B80, },		// MA_CTEXTURE_DRAW_IN_RECT_FUNCTION,
		{ 0x0057B9FD, memory_und, 0x0057B9FD, 0x0057BF71, },		// MA_CALL_CTEXTURE_DRAW_BG_RECT,

		{ 0x00464C00, memory_und, 0x00464C00, 0x00464C80, },		// MA_ADD_SCRIPT_TO_QUEUE_FUNCTION,
		{ 0x00464BD0, memory_und, 0x00464BD0, 0x00464C50, },		// MA_REMOVE_SCRIPT_FROM_QUEUE_FUNCTION,
		{ 0x00465AA0, memory_und, 0x00465AA0, 0x00465B20, },		// MA_STOP_SCRIPT_FUNCTION,
		{ 0x00465E60, memory_und, 0x00465E60, 0x00465EE0, },		// MA_SCRIPT_OPCODE_HANDLER0_FUNCTION,
		{ 0x00464080, memory_und, 0x00464080, 0x00464100, },		// MA_GET_SCRIPT_PARAMS_FUNCTION,
		{ 0x00464500, memory_und, 0x00464500, 0x00464580, },		// MA_TRANSMIT_SCRIPT_PARAMS_FUNCTION,
		{ 0x00464370, memory_und, 0x00464370, 0x004643F0, },		// MA_SET_SCRIPT_PARAMS_FUNCTION,
		{ 0x004859D0, memory_und, 0x004859D0, 0x00485A50, },		// MA_SET_SCRIPT_COND_RESULT_FUNCTION,
		{ 0x00464700, memory_und, 0x00464700, 0x00464780, },		// MA_GET_SCRIPT_PARAM_POINTER1_FUNCTION,
		{ 0x00463D50, memory_und, 0x00463D50, 0x00463DD0, },		// MA_GET_SCRIPT_STRING_PARAM_FUNCTION,
		{ 0x00464790, memory_und, 0x00464790, 0x00464810, },		// MA_GET_SCRIPT_PARAM_POINTER2_FUNCTION,
		{ 0x00468D50, memory_und, 0x00468D50, 0x00468DD0, },		// MA_INIT_SCM_FUNCTION,
		{ 0x005D4C40, memory_und, 0x005D4C40, 0x005D5420, },		// MA_SAVE_SCM_DATA_FUNCTION,
		{ 0x005D4FD0, memory_und, 0x005D4FD0, 0x005D57B0, },		// MA_LOAD_SCM_DATA_FUNCTION,
		{ 0x00B7CB84, memory_und, 0x00B7CB84, 0x00B7F204, },		// MA_GAME_TIMER,
		{ 0x00A43C78, memory_und, 0x00A43C78, 0x00A462F8, },		// MA_OPCODE_PARAMS,
		{ 0x00A49960, memory_und, 0x00A49960, 0x00A4BFE0, },		// MA_SCM_BLOCK,
		{ 0x00A48960, memory_und, 0x00A48960, 0x00A4AFE0, },		// MA_MISSION_LOCALS,
		{ 0x00A444B1, memory_und, 0x00A444B1, 0x00A46B31, },		// MA_MISSION_LOADED,
		{ 0x00A7A6A0, memory_und, 0x00A7A6A0, 0x00A7CD20, },		// MA_MISSION_BLOCK,
		{ 0x00A476AC, memory_und, 0x00A476AC, 0x00A49D2C, },		// MA_ON_MISSION_FLAG,
		{ 0x00A8B42C, memory_und, 0x00A8B42C, 0x00A8DAAC, },		// MA_ACTIVE_THREAD_QUEUE,
		{ 0x00A8B428, memory_und, 0x00A8B428, 0x00A8DAA8, },		// MA_INACTIVE_THREAD_QUEUE,
		{ 0x00A8B430, memory_und, 0x00A8B430, 0x00A8DAB0, },		// MA_STATIC_THREADS,
		{ 0x0053BDD7, memory_und, 0x0053BDD7, memory_und, },		// MA_CALL_INIT_SCM1,
		{ 0x005BA340, memory_und, 0x005BA340, memory_und, },		// MA_CALL_INIT_SCM2,
		{ 0x005D4FD7, memory_und, 0x005D4FD7, 0x005D57B7, },		// MA_CALL_INIT_SCM3,
		{ 0x005D14D5, memory_und, 0x005D14D5, 0x005D157C, },		// MA_CALL_SAVE_SCM_DATA,
		{ 0x005D18F0, memory_und, 0x005D18F0, 0x005D20D0, },		// MA_CALL_LOAD_SCM_DATA,
		{ 0x004667DB, memory_und, 0x004667DB, 0x0046685B, },		// MA_OPCODE_004E,

		{ 0x008A6168, memory_und, 0x008A6168, 0x008A7450, },		// MA_OPCODE_HANDLER,
		{ 0x00469FEE, memory_und, 0x00469FEE, 0x0046A06E, },		// MA_OPCODE_HANDLER_REF,
		{ 0x00B74490, memory_und, 0x00B74490, 0x00B76B10, },		// MA_PED_POOL,
		{ 0x00B74494, memory_und, 0x00B74494, 0x00B76B14, },		// MA_VEHICLE_POOL,
		{ 0x00B7449C, memory_und, 0x00B7449C, 0x00B76B18, },		// MA_OBJECT_POOL,
		{ 0x00744FB0, memory_und, 0x00744FB0, 0x007457E0, },		// MA_GET_USER_DIR_FUNCTION,
		{ 0x00569660, memory_und, 0x00569660, 0x00569B00, },		// MA_FIND_GROUND_Z_FUNCTION,
		{ 0x00BA86F0, memory_und, 0x00BA86F0, 0x00BAAD70, },		// MA_RADAR_BLIPS,
		{ 0x00C2B9C8, memory_und, 0x00C2B9C8, 0x00C2E188, },		// MA_HANDLING,
		{ 0x0056E210, memory_und, 0x0056E210, 0x0056E6B0, },		// MA_GET_PLAYER_PED_FUNCTION,
		{ 0x00A9B0C8, memory_und, 0x00A9B0C8, 0x00A9D748, },		// MA_MODELS,
		{ 0x0043A0B0, memory_und, 0x0043A0B0, 0x0043A136, },		// MA_SPAWN_CAR_FUNCTION,

		{ 0x00588BE0, memory_und, 0x00588BE0, 0x005893B0, },		// MA_TEXT_BOX_FUNCTION,
		{ 0x0069F2B0, memory_und, 0x0069F2B0, 0x0069FAD0, },		// MA_STYLED_TEXT_FUNCTION,
		{ 0x0069F0B0, memory_und, 0x0069F0B0, 0x0069F8D0, },		// MA_TEXT_LOW_PRIORITY_FUNCTION,
		{ 0x0069F1E0, memory_und, 0x0069F1E0, 0x0069FA00, },		// MA_TEXT_HIGH_PRIORITY_FUNCTION,
		{ 0x006A0000, memory_und, 0x006A0000, 0x006A0820, },		// MA_CTEXT_TKEY_LOCATE_FUNCTION,
		{ 0x006A0050, memory_und, 0x006A0050, 0x006A0870, },		// MA_CALL_CTEXT_LOCATE,
		{ 0x00C1B340, memory_und, 0x00C1B340, 0x00C1DB00, },		// MA_GAME_TEXTS,
		{ 0x00969110, memory_und, 0x00969110, 0x0096B790, },		// MA_CHEAT_STRING,
		{ 0x00B72910, memory_und, 0x00B72910, 0x00B74F90, },		// MA_MPACK_NUMBER,

		{ 0x00745560, memory_und, 0x00745560, 0x00745D90, },		// MA_CREATE_MAIN_WINDOW_FUNCTION,
		{ 0x007487A8, memory_und, 0x007487F8, 0x0074907C, },		// MA_CALL_CREATE_MAIN_WINDOW,
		{ 0x00B6F028, memory_und, 0x00B6F028, 0x00B716A8, },		// MA_CAMERA,
	};

	memory_pointer GameVersionManager::TranslateMemoryAddress(MemoryAddress addrId)
	{
		return MemoryAddresses[addrId][GetGameVersion()];
	}

	extern "C"
	{
		GameVersion STDCALL CLEO_GetGameVersion() asm("__CLEO_GetGameVersion@0");
		int STDCALL CLEO_GetVersion() asm("__CLEO_GetVersion@0");
		GameVersion STDCALL CLEO_GetGameVersion()
		{
			return determineGameVersion();
		}
		
		int STDCALL CLEO_GetVersion()
		{
			return 0x04020000;
		}
	}
}
