#include "TextManager.h"
#include "CleoInstance.h"
#include "FileEnumerator.h"
#include <fstream>
#include <sstream>
#include <direct.h>

namespace CLEO
{
	CText *gameTexts;
	char *cheatString;
	BYTE *mpackNumber;
	void CDECL (*TextBox)(const char *text, bool flag1, bool infinite, bool flag2);
	void CDECL (*StyledText)(const char *text, unsigned time, unsigned style);
	void CDECL (*TextLowPriority) (const char *text, unsigned time, bool flag1, bool flag2);
	void CDECL (*TextHighPriority) (const char *text, unsigned time, bool flag1, bool flag2);
	const char *THISCALL (*CText__TKey__locate)(CText::TKey *key, const char *gxt, bool& found);

	char message_buf[0x80];
	void ShowTextBox(const char *text, bool infinite)
	{
		TextBox(text, false, infinite, false);
	}

	void RemoveTextBox()
	{
		TextBox(nullptr, false, false, false);
	}

	void ShowStyledText(const char *text, unsigned time, unsigned style)
	{
		strcpy(message_buf, text);
		StyledText(message_buf, time, style - 1);
	}

	void ShowTextLowPriority(const char *text, unsigned time)
	{
		strcpy(message_buf, text);
		TextLowPriority(message_buf, time, false, false);
	}

	void ShowTextHighPriority(const char *text, unsigned time)
	{
		strcpy(message_buf, text);
		TextHighPriority(message_buf, time, false, false);
	}

	bool TestCheat(const char* cheat)
	{
		char *c = cheatString;
		char buf[30];
		strcpy(buf, cheat);
		char *s = _strrev(buf);
		while (*s && toupper(*s++) == *c++) ;
		if (*s) return false;
		cheatString[0] = 0;
		return true;
	}

	const char *THISCALL CText__locate(CText *text, const char *gxt)
	{
		bool found; const char *result;
		if ((*gxt == '\0') || (*gxt == ' ')) return "";
		result = GetThisInstance().textManager.LocateFxt(gxt);
		if (result) return result;
		result = CText__TKey__locate(&text->tkeyMain, gxt, found);
		if (!found)
			if (text->missionLoaded || *mpackNumber || text->haveTabl)
			{
				result = CText__TKey__locate(&text->tkeyMission, gxt, found);
				if (!found)	return "";
			}
		return result;
	}

	const char fxt_mask[] = "./*.fxt";
	const char fxt_dir[] = "./cleo/cleo_text";

	TextManager::TextManager() : fxts(1, crc32FromUpcaseStdString)	
	{ 
		char cwd[MAX_PATH];
		_getcwd(cwd, sizeof(cwd));
		chdir(fxt_dir);
		// parse FXT files
		enumerate_files(fxt_mask, [this](const char *fname)
			{
				TRACE("Parsing FXT file %s", fname);
				try
				{
					std::ifstream stream(fname);
					ParseFxtFile(stream);
				}
				catch (std::exception& ex)
				{
					std::ostringstream ss;
					ss << "Loading of FXT file " << fname << " failed\n";
					ss << ex.what();
					Warning(ss.str().c_str());
				}
			});
		chdir(cwd);
	}

	bool TextManager::AddFxt(const char *key, const char *value, bool dynamic)
	{
		// TODO: replace this part with in-place construction of FxtEntry,
		// when it will be implemented in libstdc++
		if (fxts.find(key) != fxts.end()) 
		{
			TRACE("Attempting to add new FXT \'%s\' with value \"%s\" "
				  "- FAILED (FXT with the same name already exists)", key, value);
			return false;
		}
		TRACE("New FXT[%s] = %s, dynamic = %d", key, value, static_cast<int>(dynamic));
		fxts[key] = new FxtEntry(value, !dynamic);
		return true;
	}

	bool TextManager::RemoveFxt(const char *key)
	{
		TRACE("Deleting FXT[%s]", key);
		return fxts.erase(key) != 0;
	}

	const char *TextManager::LocateFxt(const char *key)
	{
		const_fxt_iterator found = fxts.find(key);
		if (found == fxts.end()) return nullptr;
		return found->second->text.c_str();
	}

	void TextManager::ClearDynamicFxts()
	{
		TRACE("Deleting dynamic fxts...");
//		size_t count = 0, total = fxts.size();
		for (auto it = fxts.begin(); it != fxts.end();)
		{
			if (!it->second->is_static)
			{
				delete it->second;
				fxts.erase(it++);
//				++count;
			}
			else ++it;
		}
//		TRACE("Deleting finished, %d elements erased, %d elements left",
//			count, total - count);
	}

	TextManager::~TextManager() 
	{
		TRACE("Deleting fxts...");
		size_t count = 0;
		for (auto it = fxts.begin(); it != fxts.end();)
		{
			delete it->second;
			fxts.erase(it++);
			++count;
		}
//		TRACE("Deleting finished, %d elements erased", count);
	}

	void TextManager::inject(CodeInjector& inj)
	{
		TRACE("Injecting TextManager...");
		GameVersionManager& gvm = GetThisInstance().versionManager;
		TextBox = gvm.TranslateMemoryAddress(MA_TEXT_BOX_FUNCTION);
		StyledText = gvm.TranslateMemoryAddress(MA_STYLED_TEXT_FUNCTION);
		TextLowPriority = gvm.TranslateMemoryAddress(MA_TEXT_LOW_PRIORITY_FUNCTION);
		TextHighPriority = gvm.TranslateMemoryAddress(MA_TEXT_HIGH_PRIORITY_FUNCTION);
		CText__TKey__locate = gvm.TranslateMemoryAddress(MA_CTEXT_TKEY_LOCATE_FUNCTION);
		gameTexts = gvm.TranslateMemoryAddress(MA_GAME_TEXTS);
		cheatString = gvm.TranslateMemoryAddress(MA_CHEAT_STRING);
		mpackNumber = gvm.TranslateMemoryAddress(MA_MPACK_NUMBER);
		inj.InjectFunction(CText__locate, gvm.TranslateMemoryAddress(MA_CALL_CTEXT_LOCATE));
	}

	TextManager::FxtEntry::FxtEntry(const char *_text, bool _static)
				: text(_text), is_static(_static) { }

	void TextManager::ParseFxtFile(std::istream& stream)
	{
		static char buf[0x100];
		char *key_iterator, *value_iterator, *value_start, *key_start;
		stream.exceptions(std::ios::badbit);
		while (true)
		{
			stream.getline(buf, sizeof(buf));
			if (stream.fail() || stream.eof()) break;
			// parse extracted line	
			key_start = key_iterator = buf;
			while (*key_iterator)
			{
				if (*key_iterator == '#')	// start of comment
					break;
				if (isspace(*key_iterator))
				{
					*key_iterator = '\0';
					// while (isspace(*++key_iterator)) ; // skip leading spaces
					value_start = value_iterator = key_iterator + 1;
					while (*value_iterator)
					{
						// start of comment
						if (*value_iterator == '#')
						{
							*value_iterator = '\0'; 
							break;
						}
						value_iterator++;
					}
					// register found fxt entry
					AddFxt(key_start, value_start, false);
					break;
				}
				key_iterator++;
			}
		}
	}
}
