#pragma once
#include "CText.h"
#include "CodeInjector.h"
#include "crc32.h"
#include <string>
#include <tr1/unordered_map>

namespace CLEO
{
	class TextManager : iInjectible
	{
		class FxtEntry
		{
			friend class TextManager;
			std::string text;
			bool is_static;
			FxtEntry(const char *_text, bool _static = false);
		};
		typedef std::tr1::unordered_map<std::string, FxtEntry *,
			decltype(&crc32FromUpcaseStdString)> fxt_map_type;
		typedef fxt_map_type::iterator fxt_iterator;
		typedef fxt_map_type::const_iterator const_fxt_iterator;
		fxt_map_type fxts;
	public:
		TextManager();
		~TextManager();
		bool AddFxt(const char *key, const char *value, bool dynamic = true);
		bool RemoveFxt(const char *key);
		// find fxt text by its key
		const char *LocateFxt(const char *key);
		// erase all fxts, added by scripts
		void ClearDynamicFxts();
		void ParseFxtFile(std::istream& stream);
		virtual void inject(CodeInjector& inj);
	};

	void ShowTextBox(const char *text, bool infinite = false);
	void RemoveTextBox();
	void ShowStyledText(const char *text, unsigned time, unsigned style);
	void ShowTextLowPriority(const char *text, unsigned time);
	void ShowTextHighPriority(const char *text, unsigned time);

	bool TestCheat(const char* cheat);
	extern CText *gameTexts;
	const char *THISCALL CText__locate(CText *text, const char *gxt);
}
