#include <windows.h>
#include "CleoInstance.h"
#include "DebugLog.h"

extern "C" BOOL WINAPI DllMain(HINSTANCE hinstDLL, DWORD fdwReason, LPVOID lpvReserved)
{
	auto gv = CLEO::GetThisInstance().versionManager.GetGameVersion();
	switch (fdwReason)
	{
	case DLL_PROCESS_ATTACH:
		TRACE("Started on game of version: %s",
			(gv == CLEO::GV_US10)? "SA 1.0 us"  : 
			(gv == CLEO::GV_EU11)? "SA 1.01 eu" : 
			(gv == CLEO::GV_EU10)? "SA 1.0 eu" : 
			"<!unknown!>");
		if (gv != CLEO::GV_US10 && gv != CLEO::GV_EU11 && gv != CLEO::GV_EU10)
			Error("Unknown game version.\n" 
			"The list of all supported executables:\n\n"
			"  1) gta_sa.exe, original 1.0 us, 14 405 632 bytes;\n"
			"  2) gta_sa.exe, public no-dvd 1.0 us, 14 383 616 bytes;\n"
			"  3) gta_sa_compact.exe, listener's executable, 5 189 632 bytes;\n"
			"  4) gta_sa.exe, original 1.01 eu, 14 405 632 bytes;\n"
			"  5) gta_sa.exe, public no-dvd 1.01 eu, 15 806 464 bytes;\n"
			"  6) gta_sa.exe, 1C localization, 15 806 464 bytes;\n"
			"  7) gta_sa.exe, original 1.0 eu, unknown size;\n"
			"  8) gta_sa.exe, public no-dvd 1.0eu, 14 386 176 bytes."
			);
		CLEO::GetThisInstance().start();
		break;
	case DLL_PROCESS_DETACH:
		CLEO::GetThisInstance().stop();
		break;
	}
	return TRUE;
}
