#pragma once
#include "CodeInjector.h"
#include "RwV3d.h"

struct REVERSED RwQuat
{
	RwV3d imag;
	float real;
	RwQuat(float _x, float _y, float _z, float _r) :
		imag(_x, _y, _z), real(_r) { }
	RwQuat(const RwV3d& v3d, float _r) :
		imag(v3d), real(_r) { }
	RwQuat(const float *r) : imag(r), real(r[3]) { }
};

VALIDATE_SIZE(RwQuat, 16);