--By Trifecta 2015
--Semi-Scripted Bank Heist(Bank Security Addon

local PacificGuards = {}

function PacificGuards.unload()
end
function PacificGuards.init()
end

--EDITABLE VARIABLES MADE EASY--
--EDIT THE FOLLOWING SO YOU WON'T HAVE TO SEARCH THE CODE FOR THE CORRECT LINE--
local guardWeaponHash = GAMEPLAY.GET_HASH_KEY("WEAPON_PISTOL")

--------------------------------------------------------------------------------

--DO NOT EDIT THESE OR RISK BREAKING GUARDS--
local spawned = false
local alerted = false
local startup = true



function PacificGuards.tick()
	local playerPed = PLAYER.PLAYER_PED_ID()
	local location = ENTITY.GET_ENTITY_COORDS(playerPed, nil)
	
	--print(GAMEPLAY.GET_DISTANCE_BETWEEN_COORDS( 234.660,221.590,106.287 , location.x, location.y, location.z, true ))
	
	if(ENTITY.IS_ENTITY_DEAD(playerPed)) then
		despawnGuard()
	end
	
	if((spawned == false) and ((GAMEPLAY.GET_DISTANCE_BETWEEN_COORDS( 232.343,215.314,106.287, location.x, location.y, location.z, true ) < 2) or (GAMEPLAY.GET_DISTANCE_BETWEEN_COORDS( 260.985,208.228,106.283, location.x, location.y, location.z, true ) < 2))) then
		print("spawn")
		spawnGuard()
		spawned = true

	elseif((GAMEPLAY.GET_DISTANCE_BETWEEN_COORDS( 243.282, 210.174,106.287 , location.x, location.y, location.z, true ) < 30) and (PED.IS_PED_SHOOTING(playerPed) == true) and (alerted == false)) then
		alertGuards()
	end

end

--DO NOT EDIT THE FOLLOWING LOCAL VARIABLES UNLESS YOU KNOW WHAT YOU'RE DOING-----
local guardPed = {}
local spawnX = {246.580,256.948, 253.429,264.849,265.655,262.412,252.858} --X
local spawnY = {214.330,226.059, 229.212,219.331,221.634,222.955,227.709} --Y
local spawnZ = {106.287,106.287, 106.287,110.283,110.283,101.683,101.683} --Z
local spawnH = {0,180,180,0,180,0,270} --HEADING
local numberOfGuards = 7 --NUMBER OF GUARDS MUST BE EQUAL TO THE AMOUNT OF ELEMENTS IN THE ARRAY
----------------------------------------------------------------------------------
function spawnGuard()
	GuardID = GAMEPLAY.GET_HASH_KEY("s_m_m_security_01")
	STREAMING.REQUEST_MODEL(GuardID)
	while(not STREAMING.HAS_MODEL_LOADED(GuardID)) do
				wait(50)
	end

	for i = 1, numberOfGuards do
		guardPed[i] = PED.CREATE_PED(1, GuardID, spawnX[i], spawnY[i], spawnZ[i], spawnH[i], true, true)
		PED.SET_PED_CAN_SWITCH_WEAPON(guardPed[i], true)
		WEAPON.GIVE_DELAYED_WEAPON_TO_PED(guardPed[i], guardWeaponHash, 1000, false)
		PED.SET_PED_RELATIONSHIP_GROUP_HASH(guardPed[i], GAMEPLAY.GET_HASH_KEY("army"))
		print(i)
	end
	STREAMING.SET_MODEL_AS_NO_LONGER_NEEDED(GuardID)
	spawned = true
end

function alertGuards()
	GuardID = GAMEPLAY.GET_HASH_KEY("s_m_m_security_01")
	
	for i = 1, numberOfGuards do
		AI.TASK_COMBAT_PED(guardPed[i], PLAYER.PLAYER_PED_ID(),1 ,1)
		ENTITY.SET_ENTITY_INVINCIBLE(guardPed[i], false)
	end
	
	alerted = true
	
	STREAMING.SET_MODEL_AS_NO_LONGER_NEEDED(GuardID)
end

function despawnGuards()
	
	for i = 1, numberOfGuards do
		PED.DELETE_PED(guardPed[i])
	end
	
	spawned = false
	alerted = false
	startup = true
end



return PacificGuards