--By Trifecta 2015
--Semi-Scripted Bank Heist

local PacificSandboxHeist = {}



function markBank()
		bankBlip = UI.ADD_BLIP_FOR_COORD(229.367,213.836,105.531)
		UI.SET_BLIP_SCALE(bankBlip, 1)
		UI.SET_BLIP_SPRITE(bankBlip, 52)
		UI.SET_BLIP_COLOUR(bankBlip, 5)
		UI.SET_BLIP_AS_SHORT_RANGE(bankBlip, true)
end

--Part 1 = Gate
--Part 2 = Open Safe
--Part 3 = Get Cash
--Part 4 = Escape
--Part 5 = Drop-Off

--EDITABLE VARIABLES MADE EASY--
--EDIT THE FOLLOWING SO YOU WON'T HAVE TO SEARCH THE CODE FOR THE CORRECT LINE--
local PayoutMin = 1000000
local PayoutMax = 2500000

local wantedLevelPt1 = 1
local wantedLevelPt2 = 2
local wantedLevelPt3 = 3
local wantedLevelPt4 = 4

local safeWaitTime = 20000 --Milliseconds
--------------------------------------------------------------------------------

--DO NOT EDIT----------------------------
heistPart = 0
local timeFlag = {}
	timeFlag[0] = false
	timeFlag[1] = false
	timeFlag[2] = false
local dropOffBlip
local flag01 = false --Near Vault
local flag02 = false --Get Payment
local flag03 = {} --Deposit Boxes
local flag04 = false --Pickup Money
local flag05 = false --Create Pickup Money
local flag06 = false --Spawn Swat
local depoFlag = {}
	depoFlag[0] = false
	depoFlag[1] = false
	depoFlag[2] = false
local bankCashPickup
local depoPay = 0
local obj = {}
local blip = {}
local timerActive = false
-----------------------------------------
-- COORDINATES:
-- VAULT 1ST GATE: 252.318,220.605,101.808

-- MONEY PICKUP: 264.144,213.632,102.528
-- DEPOSIT 1: 266.073,213.662,101.683
-- DEPOSIT 2: 263.447,212.503,101.683
-- DEPOSIT 3: 264.498, 216.189, 101.683

markBank()

function PacificSandboxHeist.unload() end

function PacificSandboxHeist.init()
	for i = 1,4 do
		flag03[i] = false
	end
end

--NOT USED, SCRIPTED EXPLOSION. DOESN'T ALWAYS WORK. WILL USE IT WHEN NATIVE GETS UPDATED
function explosion()	
	--255.745,225.310,101.876
	FIRE.ADD_EXPLOSION(253.551, 223.934, 101.900, 5, 0.5, false, false, 1)
	FIRE.ADD_EXPLOSION(252.260,225.383,101.683, 5, 0.5, false, false, 1)
	wait(1000)
	obj[1] = OBJECT.CREATE_OBJECT(GAMEPLAY.GET_HASH_KEY("prop_weight_20k"),255.745,225.310,101.876, false,false,true)
	OBJECT.PLACE_OBJECT_ON_GROUND_PROPERLY(obj[1])
	obj[2] = OBJECT.CREATE_OBJECT(GAMEPLAY.GET_HASH_KEY("prop_weight_20k"),255.521,225.734,101.876, false,false,true)
	OBJECT.PLACE_OBJECT_ON_GROUND_PROPERLY(obj[2])
end

function setBlipDropOff()
	dropOffBlip = UI.ADD_BLIP_FOR_COORD(1378.405, -2078.464, 51.999)
	UI.SET_BLIP_COLOUR(dropOffBlip, 16742399)
	UI.SET_BLIP_SCALE(dropOffBlip, 1)
	UI.SET_BLIP_FLASHES(dropOffBlip, true)
	UI.SET_BLIP_ROUTE(dropOffBlip, true)
end

function setBlips()
	blip[4] = UI.ADD_BLIP_FOR_COORD(264.144,213.632,102.528)
	UI.SET_BLIP_COLOUR(blip[4], 16742399)
	UI.SET_BLIP_SCALE(blip[4], 1)
	UI.SET_BLIP_FLASHES(blip[4], true)
	UI.SET_BLIP_ROUTE(blip[4], true)
	
	blip[1] = UI.ADD_BLIP_FOR_COORD(266.073,213.662,101.683)
	UI.SET_BLIP_COLOUR(blip[1], 16742399)
	UI.SET_BLIP_SCALE(blip[1], 1)
	UI.SET_BLIP_FLASHES(blip[1], true)

	
	blip[2] = UI.ADD_BLIP_FOR_COORD(263.447,212.503,101.683)
	UI.SET_BLIP_COLOUR(blip[2], 16742399)
	UI.SET_BLIP_SCALE(blip[2], 1)
	UI.SET_BLIP_FLASHES(blip[2], true)

	
	blip[3] = UI.ADD_BLIP_FOR_COORD(264.498, 216.189, 101.683)
	UI.SET_BLIP_COLOUR(blip[3], 16742399)
	UI.SET_BLIP_SCALE(blip[3], 1)
	UI.SET_BLIP_FLASHES(blip[3], true)

end

function removeBlip(i)
	UI.REMOVE_BLIP(blip[i])
end

function drawText(text, x, y, scale)
  UI.SET_TEXT_FONT(6)
  UI.SET_TEXT_SCALE(scale, scale)
  UI.SET_TEXT_COLOUR(255, 255, 255, 255)
  UI.SET_TEXT_WRAP(0.0, 1.0)
  UI.SET_TEXT_CENTRE(false)
  UI.SET_TEXT_DROPSHADOW(2, 2, 0, 0, 0)
  UI.SET_TEXT_EDGE(1, 0, 0, 0, 205)
  UI._SET_TEXT_ENTRY("STRING")
  UI._ADD_TEXT_COMPONENT_STRING(text)
  UI._DRAW_TEXT(y, x)
end

function PacificSandboxHeist.tick() 

	local playerPed = PLAYER.PLAYER_PED_ID()
	local player = PLAYER.GET_PLAYER_PED(playerPed)
	local location = ENTITY.GET_ENTITY_COORDS(playerPed, nil)
	
	--Is Player Dead?
	if((ENTITY.IS_ENTITY_DEAD(playerPed) == true) and  (heistPart > 0))then
		resetHeist()
	end
	
	--MAIN HEIST--
	--PART 1
	if ((GAMEPLAY.GET_DISTANCE_BETWEEN_COORDS( 257.055, 221.135, 106.286 , location.x, location.y, location.z, true ) < 1 ) and (heistPart == 0)) then
		
		heistPart = 1 --Start Heist
		
		notify("Make your way to the safe!")
		
		PLAYER.SET_PLAYER_WANTED_LEVEL_NO_DROP(PLAYER.GET_PLAYER_PED(playerPed),wantedLevelPt1,false)
		PLAYER.SET_PLAYER_WANTED_LEVEL_NOW(PLAYER.GET_PLAYER_PED(playerPed),false)
				
		heistPart = 2 --Move to part 2
		
		
	--PART 2
	elseif((GAMEPLAY.GET_DISTANCE_BETWEEN_COORDS( 254.034, 225.233, 100.663 , location.x, location.y, location.z, true ) < 6) and (heistPart == 2) and (ENTITY.IS_ENTITY_DEAD(playerPed) == false)) then
		
		
		PLAYER.SET_PLAYER_WANTED_LEVEL_NO_DROP(PLAYER.GET_PLAYER_PED(playerPed),wantedLevelPt2,false)
		PLAYER.SET_PLAYER_WANTED_LEVEL_NOW(PLAYER.GET_PLAYER_PED(playerPed),false)
		
		if(flag01 == false) then --Near Safe
			notify("Open The Vault Door! Plant and detonate the Sticky Bombs at the weak spots!")
		end
		
		if(GAMEPLAY.GET_DISTANCE_BETWEEN_COORDS( 252.318,220.605,101.808, location.x, location.y, location.z, true ) < 3) then
			notify("Grab the cash!")
			notify("Press [E] to raid the deposit boxes!")
			PLAYER.SET_PLAYER_WANTED_LEVEL_NO_DROP(PLAYER.GET_PLAYER_PED(playerPed),wantedLevelPt4,false)
			PLAYER.SET_PLAYER_WANTED_LEVEL_NOW(PLAYER.GET_PLAYER_PED(playerPed),false)
			flag01 = true
			spawnNooseInside()
			heistPart = 3
			setBlips()
		end
	
	elseif((heistPart == 3) and (ENTITY.IS_ENTITY_DEAD(playerPed) == false)) then
	
		PLAYER.SET_PLAYER_WANTED_LEVEL_NO_DROP(PLAYER.GET_PLAYER_PED(playerPed),wantedLevelPt4,false)
		PLAYER.SET_PLAYER_WANTED_LEVEL_NOW(PLAYER.GET_PLAYER_PED(playerPed),false)
	
		if(flag05 == false) then
			bankCashPickup = OBJECT.CREATE_AMBIENT_PICKUP(GAMEPLAY.GET_HASH_KEY("PICKUP_MONEY_VARIABLE"), 264.287, 213.803, 102.528, 1000, 1, 1, false, true)
			OBJECT.CREATE_AMBIENT_PICKUP(GAMEPLAY.GET_HASH_KEY("PICKUP_MONEY_VARIABLE"), 264.287, 213.803, 102.528, 1000, 1, 1, false, true)
			OBJECT.CREATE_AMBIENT_PICKUP(GAMEPLAY.GET_HASH_KEY("PICKUP_MONEY_VARIABLE"), 264.287, 213.803, 102.528, 1000, 1, 1, false, true)
			OBJECT.CREATE_AMBIENT_PICKUP(GAMEPLAY.GET_HASH_KEY("PICKUP_MONEY_VARIABLE"), 264.287, 213.803, 102.528, 1000, 1, 1, false, true)
			OBJECT.CREATE_AMBIENT_PICKUP(GAMEPLAY.GET_HASH_KEY("PICKUP_MONEY_VARIABLE"), 264.287, 213.803, 102.528, 1000, 1, 1, false, true)
			OBJECT.CREATE_AMBIENT_PICKUP(GAMEPLAY.GET_HASH_KEY("PICKUP_MONEY_VARIABLE"), 264.287, 213.803, 102.528, 1000, 1, 1, false, true)
			OBJECT.CREATE_AMBIENT_PICKUP(GAMEPLAY.GET_HASH_KEY("PICKUP_MONEY_VARIABLE"), 264.287, 213.803, 102.528, 1000, 1, 1, false, true)
			OBJECT.CREATE_AMBIENT_PICKUP(GAMEPLAY.GET_HASH_KEY("PICKUP_MONEY_VARIABLE"), 264.287, 213.803, 102.528, 1000, 1, 1, false, true)
			flag05 = true
		end
		
		if(GAMEPLAY.GET_DISTANCE_BETWEEN_COORDS( 264.287, 213.803, 102.528, location.x, location.y, location.z, true ) < 2 and flag04 == false) then
			notify("You collected the cash!")
			notify("Escape, or go for the deposit boxes!")
			notify("Press [L] when you're ready to leave!")
			PED.SET_PED_COMPONENT_VARIATION(playerPed, 9, 1, 0, 0)	
			removeBlip(4)
			spawnNooseOutside()
			spawnRiotTruck()
			flag04 = true
			PLAYER.SET_PLAYER_WANTED_LEVEL_NO_DROP(PLAYER.GET_PLAYER_PED(playerPed),wantedLevelPt4,false)
			PLAYER.SET_PLAYER_WANTED_LEVEL_NOW(PLAYER.GET_PLAYER_PED(playerPed),false)
		end
		
		if(GAMEPLAY.GET_DISTANCE_BETWEEN_COORDS( 266.073,213.662,101.683 , location.x, location.y, location.z, true ) < 1 and depoFlag[0] == false) then
			if(not timeFlag[0])then
				drawText("Press [E] to raid the Deposit Box!", 0.5, 0.5, 1)
			end
			if(get_key_pressed(Keys.E) or timeFlag[0] == true)then
				drawText("Looting Deposit Box", 0.5, 0.5, 1)
				if(not timeFlag[0])then
					timerInit()
					timeFlag[0] = true
					ENTITY.FREEZE_ENTITY_POSITION(playerPed, true)
				end
				if(timer(10000) == true) then
					depoPay = depoPay + 450000
					flag03[1] = true
					removeBlip(1)
					notify("Deposit Box 1 Looted")
					print("depo1")
					depoFlag[0] = true
					ENTITY.FREEZE_ENTITY_POSITION(playerPed, false)
					PLAYER.SET_PLAYER_WANTED_LEVEL_NO_DROP(PLAYER.GET_PLAYER_PED(playerPed),wantedLevelPt4,false)
					PLAYER.SET_PLAYER_WANTED_LEVEL_NOW(PLAYER.GET_PLAYER_PED(playerPed),false)
					resetTimer()
				end
			end
		elseif(GAMEPLAY.GET_DISTANCE_BETWEEN_COORDS( 263.447,212.503,101.683 , location.x, location.y, location.z, true ) < 1 and depoFlag[1] == false) then
			if(not timeFlag[1])then
				drawText("Press [E] to raid the Deposit Box!", 0.5, 0.5, 1)
			end
			if(get_key_pressed(Keys.E) or timeFlag[1] == true)then
				drawText("Looting Deposit Box", 0.5, 0.5, 1)
				if(not timeFlag[1])then
					timerInit()
					timeFlag[1] = true
					ENTITY.FREEZE_ENTITY_POSITION(playerPed, true)
				end
				if(timer(10000) == true) then
					depoPay = depoPay + 450000
					flag03[2] = true
					removeBlip(2)
					notify("Deposit Box 2 Looted")
					print("depo2")		
					depoFlag[1] = true
					ENTITY.FREEZE_ENTITY_POSITION(playerPed, false)
					PLAYER.SET_PLAYER_WANTED_LEVEL_NO_DROP(PLAYER.GET_PLAYER_PED(playerPed),wantedLevelPt4,false)
					PLAYER.SET_PLAYER_WANTED_LEVEL_NOW(PLAYER.GET_PLAYER_PED(playerPed),false)	
					resetTimer()
				end
			end
		elseif(GAMEPLAY.GET_DISTANCE_BETWEEN_COORDS( 264.498, 216.189, 101.683 , location.x, location.y, location.z, true ) < 1 and depoFlag[2] == false) then
			if(not timeFlag[2])then
				drawText("Press [E] to raid the Deposit Box!", 0.5, 0.5, 1)
			end
			if(get_key_pressed(Keys.E) or timeFlag[2] == true)then
				drawText("Looting Deposit Box", 0.5, 0.5, 1)
				if(not timeFlag[2])then
					timerInit()
					timeFlag[2] = true
					ENTITY.FREEZE_ENTITY_POSITION(playerPed, true)
				end
				if(timer(10000) == true) then
					depoPay = depoPay + 450000
					flag03[3] = true
					removeBlip(3)
					notify("Deposit Box 3 Looted")
					print("depo3")
					depoFlag[2] = true
					ENTITY.FREEZE_ENTITY_POSITION(playerPed, false)
					PLAYER.SET_PLAYER_WANTED_LEVEL_NO_DROP(PLAYER.GET_PLAYER_PED(playerPed),wantedLevelPt4,false)
					PLAYER.SET_PLAYER_WANTED_LEVEL_NOW(PLAYER.GET_PLAYER_PED(playerPed),false)
					resetTimer()
				end
			end
		end

		if((flag04 == true and get_key_pressed(Keys.L)) or (flag03[1] == true and flag03[2] == true and flag03[3] == true and flag04 == true)) then
			ENTITY.FREEZE_ENTITY_POSITION(playerPed, false)
			heistPart = 4
			removeBlip(1)
			removeBlip(2)
			removeBlip(3)
			removeBlip(4)
			notify("Shoot your way out of the bank and escape the heat!")
		end
		
	
	
	--PART 4
	elseif((heistPart == 4) and (ENTITY.IS_ENTITY_DEAD(playerPed) == false)) then
		if(GAMEPLAY.GET_DISTANCE_BETWEEN_COORDS( 257.055, 221.135, 106.286 , location.x, location.y, location.z, true ) < 100) then
			PLAYER.SET_PLAYER_WANTED_LEVEL_NO_DROP(PLAYER.GET_PLAYER_PED(playerPed),wantedLevelPt4,false)
			PLAYER.SET_PLAYER_WANTED_LEVEL_NOW(PLAYER.GET_PLAYER_PED(playerPed),false)
		end
		
		if(PLAYER.GET_PLAYER_WANTED_LEVEL(PLAYER.GET_PLAYER_PED_SCRIPT_INDEX(playerPed))<1) then
			heistPart = 5 --Move to part 4
			setBlipDropOff()
		end
	
	--PART 5
	elseif((heistPart == 5 ) and (ENTITY.IS_ENTITY_DEAD(playerPed) == false) and (PLAYER.GET_PLAYER_WANTED_LEVEL(PLAYER.GET_PLAYER_PED_SCRIPT_INDEX(playerPed))<1) and (ENTITY.IS_ENTITY_DEAD(playerPed) == false)) then
		local pickup
		
		notify("Good job. Get to the drop off point to launder your money.")
		
		if ((PLAYER.GET_PLAYER_WANTED_LEVEL(PLAYER.GET_PLAYER_PED_SCRIPT_INDEX(playerPed))<1) and (PLAYER.GET_PLAYER_WANTED_LEVEL(PLAYER.GET_PLAYER_PED_SCRIPT_INDEX(playerPed))<1) and (GAMEPLAY.GET_DISTANCE_BETWEEN_COORDS( 1378.405, -2078.464, 51.999 , location.x, location.y, location.z, true ) < 10)) then
			
			if not(flag02) then
				math.randomseed(os.time())
				local finalPayout =math.random (PayoutMin, PayoutMax)
				pickup = OBJECT.CREATE_AMBIENT_PICKUP(GAMEPLAY.GET_HASH_KEY("PICKUP_MONEY_SECURITY_CASE"), 1378.405, -2078.464, 51.999, 0, finalPayout+depoPay, 1, false, true)
				flag02 = true
			end
			
			if(PLAYER.GET_PLAYER_WANTED_LEVEL(PLAYER.GET_PLAYER_PED_SCRIPT_INDEX(playerPed))<1) and (GAMEPLAY.GET_DISTANCE_BETWEEN_COORDS( 1378.405, -2078.464, 51.999 , location.x, location.y, location.z, true ) < 1) then
				PED.SET_PED_COMPONENT_VARIATION(playerPed, 9, 0, 0, 0)
				resetHeist()
				AUDIO.PLAY_MISSION_COMPLETE_AUDIO("MICHAEL_BIG_01")
				notify("Good Job!")
			end
		end	
	end
end

--RESETS EVERYTHING---------------------------
--DO NOT EDIT OR RISK BREAKING REPLAYABILITY--
function resetHeist() 
	despawnGuards()
	deleteSpawns()
	flag01 = false
	flag02 = false
	flag04 = false
	flag05 = false
	flag06 = false
	flag03[1] = false
	flag03[2] = false
	flag03[3] = false
	flag03[4] = false
	timeFlag[0] = false
	timeFlag[1] = false
	timeFlag[2] = false
	depoFlag[0] = false
	depoFlag[1] = false
	depoFlag[2] = false
	heistPart = 0
	UI.REMOVE_BLIP(dropOffBlip)
end

--TIMER--
local startTime

function timerInit()
	startTime = GAMEPLAY.GET_GAME_TIMER()
end

function timer(timer)
	timerActive = true
	local difference = GAMEPLAY.GET_GAME_TIMER() - startTime
	if(difference >= timer)then
		return true
	else return false
	end
end

function resetTimer()
	startTime = -1
	timerActive = false
end

function getTimerState()
	return timerActive
end

return PacificSandboxHeist